/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.adaptors.jms;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.base.VWDebug;
import filenet.vw.integrator.adaptors.jms.VWEventItem;
import filenet.vw.integrator.adaptors.jms.VWParameterItem;
import filenet.vw.integrator.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.table.AbstractTableModel;

public class VWParameterTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 3;
    public static final int COL_NAME = 0;
    public static final int COL_TYPE = 1;
    public static final int COL_DESCRIPTION = 2;
    private static final String s_array = "[ ]";
    private VWEventItem m_eventItem = null;
    private JDialog m_parentDialog = null;
    private JComboBox m_parameterTypeComboBox = null;
    private Vector m_rowData = null;
    private boolean m_bIsModified = false;
    private String m_type = null;
    private String m_description = null;

    public VWParameterTableModel(JDialog parentDialog) {
        try {
            this.m_parentDialog = parentDialog;
            this.m_type = VWFieldType.getLocalizedString(4);
            this.m_description = new String();
            this.m_rowData = new Vector();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public JComboBox getParameterTypeComboBox() {
        try {
            if (this.m_parameterTypeComboBox == null) {
                this.m_parameterTypeComboBox = new JComboBox();
                this.m_parameterTypeComboBox.addItem(VWFieldType.getLocalizedString(32));
                this.m_parameterTypeComboBox.addItem(VWFieldType.getLocalizedString(32) + s_array);
                this.m_parameterTypeComboBox.addItem(VWFieldType.getLocalizedString(4));
                this.m_parameterTypeComboBox.addItem(VWFieldType.getLocalizedString(4) + s_array);
                this.m_parameterTypeComboBox.addItem(VWFieldType.getLocalizedString(8));
                this.m_parameterTypeComboBox.addItem(VWFieldType.getLocalizedString(8) + s_array);
                this.m_parameterTypeComboBox.addItem(VWFieldType.getLocalizedString(1));
                this.m_parameterTypeComboBox.addItem(VWFieldType.getLocalizedString(1) + s_array);
                this.m_parameterTypeComboBox.addItem(VWFieldType.getLocalizedString(2));
                this.m_parameterTypeComboBox.addItem(VWFieldType.getLocalizedString(2) + s_array);
                this.m_parameterTypeComboBox.addItem(VWFieldType.getLocalizedString(16));
                this.m_parameterTypeComboBox.addItem(VWFieldType.getLocalizedString(16) + s_array);
                this.m_parameterTypeComboBox.addItem(VWResource.s_workflowGroup);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_parameterTypeComboBox;
    }

    public boolean isModified() {
        return this.m_bIsModified;
    }

    public void refresh(VWEventItem operationDef) {
        try {
            VWParameterItem[] parameterItems;
            this.m_eventItem = operationDef;
            this.m_rowData.removeAllElements();
            if (this.m_eventItem != null && (parameterItems = this.m_eventItem.getParameterItems()) != null && parameterItems.length > 0) {
                for (int i = 0; i < parameterItems.length; ++i) {
                    this.m_rowData.addElement(parameterItems[i]);
                }
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void deleteItem(int nRowIndex) {
        try {
            VWParameterItem parameterItem = this.getRowItemAt(nRowIndex);
            if (parameterItem != null) {
                this.m_eventItem.deleteParameterItem(parameterItem.getName());
                this.m_rowData.removeElementAt(nRowIndex);
                this.m_bIsModified = true;
                this.fireTableRowsDeleted(nRowIndex, nRowIndex);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentDialog, ex.getLocalizedMessage(), 1);
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWResource.s_name;
            }
            case 1: {
                return VWResource.s_type;
            }
            case 2: {
                return VWResource.s_description;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_eventItem != null && this.m_rowData != null) {
            return this.m_rowData.size() + 1;
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWParameterItem parameterItem = this.getRowItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (parameterItem != null) {
                        return parameterItem.getName();
                    }
                    return new String();
                }
                case 1: {
                    return this.getParameterTypeString(parameterItem);
                }
                case 2: {
                    if (parameterItem != null) {
                        return parameterItem.getDescription();
                    }
                    return this.m_description;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return true;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                this.onUpdateName(aValue, nRowIndex);
                break;
            }
            case 1: {
                this.onUpdateType(aValue, nRowIndex);
                break;
            }
            case 2: {
                this.onUpdateDescription(aValue, nRowIndex);
            }
        }
    }

    public VWParameterItem getRowItemAt(int nRowIndex) {
        VWParameterItem parameterItem = null;
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            parameterItem = (VWParameterItem)this.m_rowData.elementAt(nRowIndex);
        }
        return parameterItem;
    }

    private void onUpdateName(Object aValue, int nRowIndex) {
        try {
            if (aValue == null || !(aValue instanceof String)) {
                return;
            }
            String newName = (String)aValue;
            if (newName.length() == 0) {
                return;
            }
            VWParameterItem parameterItem = this.getRowItemAt(nRowIndex);
            if (parameterItem != null) {
                if (VWStringUtils.compare(newName, parameterItem.getName()) == 0) {
                    return;
                }
                VWParameterItem existingParamItem = this.m_eventItem.getParameterItem(newName);
                if (existingParamItem != null) {
                    throw new VWException("vw.integrator.parameterAlreadyExists", "A parameter with this name already exists.");
                }
                parameterItem.setName(newName);
                this.m_bIsModified = true;
                this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            } else {
                parameterItem = this.m_eventItem.createParameterItem(newName, this.getParameterType(this.m_type), this.isArrayType(this.m_type));
                if (parameterItem != null) {
                    parameterItem.setDescription(this.m_description);
                    this.m_description = new String();
                    this.m_rowData.addElement(parameterItem);
                    this.m_bIsModified = true;
                    this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentDialog, ex.getLocalizedMessage(), 1);
        }
    }

    private void onUpdateType(Object aValue, int nRowIndex) {
        try {
            if (aValue == null) {
                return;
            }
            String newType = aValue.toString();
            int nFieldType = this.getParameterType(newType);
            boolean isArray = this.isArrayType(newType);
            VWParameterItem parameterItem = this.getRowItemAt(nRowIndex);
            if (parameterItem != null) {
                parameterItem.setType(nFieldType);
                parameterItem.setIsArray(isArray);
                this.m_bIsModified = true;
            } else {
                this.m_type = newType;
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUpdateDescription(Object aValue, int nRowIndex) {
        try {
            if (aValue == null) {
                return;
            }
            VWParameterItem parameterItem = this.getRowItemAt(nRowIndex);
            if (parameterItem != null) {
                parameterItem.setDescription(aValue.toString());
                this.m_bIsModified = true;
            } else {
                this.m_description = aValue.toString();
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private String getParameterTypeString(VWParameterItem parameterItem) {
        String type;
        block7: {
            type = null;
            try {
                if (parameterItem != null) {
                    switch (parameterItem.getType()) {
                        case 64: {
                            type = VWResource.s_workflowGroup;
                            break;
                        }
                        default: {
                            type = VWFieldType.getLocalizedString(parameterItem.getType());
                            if (parameterItem.getIsArray()) {
                                type = type + s_array;
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                    break block7;
                }
                type = this.m_type;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return type;
    }

    private int getParameterType(String type) {
        try {
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(32)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(32) + s_array) == 0) {
                return 32;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(4)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(4) + s_array) == 0) {
                return 4;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(8)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(8) + s_array) == 0) {
                return 8;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(1)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(1) + s_array) == 0) {
                return 1;
            }
            if (VWStringUtils.compare(type, VWResource.s_workflowGroup) == 0) {
                return 64;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(2)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(2) + s_array) == 0) {
                return 2;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(16)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(16) + s_array) == 0) {
                return 16;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return -1;
    }

    private boolean isArrayType(String type) {
        boolean bIsArray = false;
        try {
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(32) + s_array) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(4) + s_array) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(8) + s_array) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(1) + s_array) == 0 || VWStringUtils.compare(type, VWResource.s_workflowGroup) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(2) + s_array) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(16) + s_array) == 0) {
                bIsArray = true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return bIsArray;
    }
}

